<?php
if (headers_sent($file, $line)) {
    die("Headers already sent in $file on line $line");
}

$file_path = $_SERVER['DOCUMENT_ROOT']. '/license.php';
if (file_exists($file_path)) {
    require $file_path;
} else {
    header('Location: /license-error.php?error=file_not_found');
    exit();
}

session_start();

// Menonaktifkan tampilan pesan kesalahan
// error_reporting(E_ALL);
// Atur zona waktu ke "Asia/Jakarta" (Waktu Indonesia Barat)
date_default_timezone_set('Asia/Jakarta');
// Tampilkan tanggal dan waktu dalam format yang diinginkan
$currentDateTime = date('d M Y H:i:s');

// Mendefinisikan path fisik ke file connection.php
$path_to_connection = $_SERVER['DOCUMENT_ROOT'] . "/connection.php";
// Melakukan include file menggunakan path fisik
include $path_to_connection;

// CEK LOGIN USER
if (isset($_COOKIE['login'])) {
    $key_login = $_COOKIE['login'];
    $ciphering = "AES-128-CTR";
    $iv_length = openssl_cipher_iv_length($ciphering);
    $options = 0;
    $decryption_iv = '1234567891011121';
    $decryption_key = "ecommerce";
    $decryption = openssl_decrypt($key_login, $ciphering, $decryption_key, $options, $decryption_iv);
    $iduser_key_login = explode("hcCTZvFLD7XIchiaMqEka0TLzGgdpsXB", $decryption);
    $id_user_login = $iduser_key_login[0];
    error_log('$id_user_login : '. $id_user_login);
    $select_profile = $server->prepare("SELECT * FROM `akun` WHERE `id`=?");
    $select_profile->bind_param("i", $id_user_login);
    $select_profile->execute();
    $result = $select_profile->get_result();
    $profile = $result->fetch_assoc();

    // Jika profil tidak ditemukan, redirect ke halaman logout
    if (!$profile) {
        header('Location: ' . $url . '/system/logout.php');
        exit(); // Pastikan untuk menghentikan eksekusi setelah melakukan redirect
    }

    // Simpan informasi pemilik toko yang sedang login
    error_log('profile: '. json_encode($profile));
    $iduser = $profile['id'];

    // COUNT CART
    $count_cart_header = $server->query("SELECT * FROM `keranjang` WHERE `id_user`='$iduser' ");
    $cek_cart_header = mysqli_num_rows($count_cart_header);
    // COUNT NOTIFICATION
    $count_notif_header = $server->query("SELECT * FROM `notification` WHERE `id_user`='$iduser' AND `status_notif`='' ");
    $cek_notif_header = mysqli_num_rows($count_notif_header);
    // COUNT FAVORIT
    $count_favorit_header = $server->query("SELECT * FROM `favorit` WHERE `user_id`='$iduser' ");
    $cek_favorit_header = mysqli_num_rows($count_favorit_header);
    // COUNT CHAT
    $count_chat_header = $server->query("SELECT * FROM `chat` WHERE `penerima_user_id`='$iduser' AND `status`='' ");
    $cek_chat_header = mysqli_num_rows($count_chat_header);
    // COUNT PESANAN
    $count_pesanan_header = $server->query("SELECT * FROM `invoice` WHERE `id_user`='$iduser' AND `tipe_progress`='' ");
    $cek_pesanan_header = mysqli_num_rows($count_pesanan_header);
}

// NOTIFIKASI JUMLAH PESAN BARU
$count_unread_chat = $server->query("SELECT * FROM `chat` WHERE `penerima_user_id`='1' AND `status`=''");
$cek_unread_chat = mysqli_num_rows($count_unread_chat);
// NOTIFIKASI JUMLAH PERMINTAAN PENARIKAN
$count_pending_rows = $server->query("SELECT COUNT(*) as total FROM `riwayat_penarikan` WHERE `status`=0");
$row = $count_pending_rows->fetch_assoc();
$total_pending_rows = $row['total'];
// ADMIN MAIL
$setting_email_query = $server->query("SELECT * FROM `setting_email` WHERE `id`='1'");
$data_setting_email = mysqli_fetch_assoc($setting_email_query);
$setfrom_smtp = $data_setting_email ? $data_setting_email['setfrom_smtp'] : null;
// HEADER SETTING
$setting_header = $server->query("SELECT * FROM `setting_header` WHERE `id_hs`='1'");
$data_setting_header = mysqli_fetch_assoc($setting_header);
$logo = $data_setting_header['logo'];
$favicon = $data_setting_header['favicon'];
$title_name = $data_setting_header['title_name'];
$slogan = $data_setting_header['slogan'];
$meta_description = $data_setting_header['meta_description'];
$meta_keyword = $data_setting_header['meta_keyword'];
$google_verification = $data_setting_header['google_verification'];
$bing_verification = $data_setting_header['bing_verification'];
$ahrefs_verification = $data_setting_header['ahrefs_verification'];
$yandex_verification = $data_setting_header['yandex_verification'];
$norton_verification = $data_setting_header['norton_verification'];
// API KEY SETTING
$setting_apikey = $server->query("SELECT * FROM `setting_apikey` WHERE `id_apikey`='1'");
$data_setting_apikey = mysqli_fetch_assoc($setting_apikey);
$google_client_id = $data_setting_apikey['google_client_id'];
$google_client_secret = $data_setting_apikey['google_client_secret'];
$midtrans_client_key = $data_setting_apikey['midtrans_client_key'];
$midtrans_server_key = $data_setting_apikey['midtrans_server_key'];
$rajaongkir_key = $data_setting_apikey['rajaongkir_key'];
$tinypng_key = $data_setting_apikey['tinypng_key'];
$whatsapp_api_key = $data_setting_apikey['whatsapp_api_key'];
$whatsapp_bot_number = $data_setting_apikey['whatsapp_bot_number'];
// LOKASI TOKO
$lokasi_toko = $server->query("SELECT * FROM `setting_lokasi` WHERE `id`='1'");
$data_lokasi_toko = mysqli_fetch_assoc($lokasi_toko);
$provinsi_toko = $data_lokasi_toko['provinsi'];
$provinsi_id_toko = $data_lokasi_toko['provinsi_id'];
$kota_toko = $data_lokasi_toko['kota'];
$kota_id_toko = $data_lokasi_toko['kota_id'];
// TIPE PEMBAYARAN
$tipe_pembayaran = $server->query("SELECT * FROM `setting_pembayaran` WHERE `status`='active'");
$data_tipe_pembayaran = mysqli_fetch_array($tipe_pembayaran);
$nama_tipe_pembayaran = $data_tipe_pembayaran['tipe'];

$jumlahPesanan = array(
    'Belum Bayar' => 0,
    'Dikemas' => 0,
    'Dikirim' => 0,
    'Selesai' => 0,
    'Dibatalkan' => 0,
);
 
// Loop melalui tiap tipe progress dan hitung jumlah pesanan
foreach ($jumlahPesanan as $tipeProgress => &$jumlah) {
    // Gunakan prepared statement untuk keamanan
    $query = $server->prepare("SELECT COUNT(*) AS jumlah
                               FROM invoice
                               INNER JOIN iklan ON invoice.id_iklan = iklan.id
                               INNER JOIN akun ON iklan.user_id = akun.id
                               WHERE (iklan.user_id = ? OR akun.id = ?) AND invoice.tipe_progress = ?");
    $query->bind_param("iis", $iduser, $iduser, $tipeProgress);
    $query->execute();
    $result = $query->get_result();

    // Hitung jumlah pesanan
    $row = $result->fetch_assoc();
    $jumlah = $row['jumlah'];

    // Tutup prepared statement
    $query->close();
}

// Fungsi untuk mendapatkan jumlah tipe progress dari database
if (!function_exists('getJumlahTipeProgress')) {
    function getJumlahTipeProgress($server) {
        $jumlahTipeProgress = array();
        $query = $server->prepare("SELECT `tipe_progress`, COUNT(*) AS jumlah FROM `invoice` GROUP BY `tipe_progress`");
        $query->execute();
        $result = $query->get_result();
    
        while ($row = $result->fetch_assoc()) {
            $tipeProgress = $row['tipe_progress'];
            $jumlah = $row['jumlah'];
            $jumlahTipeProgress[$tipeProgress] = $jumlah;
        }
    
        $query->close();
        return $jumlahTipeProgress;
    }
}

// Dapatkan jumlah tipe progress
$jumlahTipeProgress = getJumlahTipeProgress($server);

// Array untuk menyimpan jumlah pesanan berdasarkan tipe progress
$jumlahPesananTerbaru = array(
    'Belum Bayar' => 0,
    'Dikemas' => 0,
    'Dikirim' => 0,
    'Selesai' => 0,
    'Dibatalkan' => 0,
);

// Loop melalui tiap tipe progress dan hitung jumlah pesanan
foreach ($jumlahPesananTerbaru as $tipeProgressTerbaruKey => &$jumlahPesananTerbaruValue) {
    // Gunakan prepared statement untuk keamanan
    $queryPesanan = $server->prepare("SELECT COUNT(*) AS jumlah FROM `invoice` WHERE `id_user` = ? AND `tipe_progress` = ?");
    $queryPesanan->bind_param("is", $iduser, $tipeProgressTerbaruKey);
    $queryPesanan->execute();
    // Dapatkan hasil query
    $resultPesanan = $queryPesanan->get_result();
    // Hitung jumlah pesanan
    $rowPesanan = $resultPesanan->fetch_assoc();
    $jumlahPesananTerbaruValue = $rowPesanan['jumlah'];
    // Tutup prepared statement
    $queryPesanan->close();
}

// Fungsi untuk mendapatkan jumlah tipe progress dari database
if (!function_exists('getJumlahTipeProgressTerbaru')) {
    function getJumlahTipeProgressTerbaru($server) {
        $jumlahTipeProgressTerbaru = array();
        $query = $server->prepare("SELECT `tipe_progress`, COUNT(*) AS jumlah FROM `invoice` GROUP BY `tipe_progress`");
        $query->execute();
        $result = $query->get_result();
        while ($row = $result->fetch_assoc()) {
            $tipeProgressTerbaru = $row['tipe_progress'];
            $jumlah = $row['jumlah'];
            $jumlahTipeProgressTerbaru[$tipeProgressTerbaru] = $jumlah;
        }
        $query->close();
        return $jumlahTipeProgressTerbaru;
    }
}

// Dapatkan jumlah tipe progress
$jumlahTipeProgressTerbaru = getJumlahTipeProgressTerbaru($server);


// Notif Wa
if (!function_exists('sendWa')) {
    function sendWa($to,$message)
    {
        global $data_setting_apikey;
        $ch = curl_init("https://wa.lapaksend.my.id/send-message");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'api_key' => $data_setting_apikey['whatsapp_api_key'],
            'sender' => $data_setting_apikey['whatsapp_bot_number'],
            'number' => format62($to),
            'message' => $message
        ]));
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        // Execute Curl request
        $response = curl_exec($ch);
    }
}

if (!function_exists('format62')) {
    function format62($input) {
        // Menghapus semua karakter kecuali angka
        $cleaned_input = preg_replace('/\D/', '', $input);
        
        // Mengubah format nomor jika dimulai dengan "0"
        if (substr($cleaned_input, 0, 1) === '0') {
            $cleaned_input = '62' . substr($cleaned_input, 1);
        }
        
        return $cleaned_input;
    }
}
